#include<p30fxxxx.h>
#include<adc10.h>

#if defined(__dsPIC30F2010__) || defined(__dsPIC30F3010__) || defined(__dsPIC30F4012__) || defined(__dsPIC30F3011__) \
    || defined(__dsPIC30F4011__) || defined(__dsPIC30F6010__) || defined(__dsPIC30F5015__)

/*********************************************************************
* Function Name     : ConfigIntADC10
* Description       : This function configures ADC Interrupt.
* Parameters        : unsigned int config
* Return Value      : None
*********************************************************************/

void ConfigIntADC10(unsigned int config)
{
    /* Clearing the Interrupt Flag bit */
    IFS0bits.ADIF = 0;
  
    /* Setting Priority */
    IPC2bits.ADIP = config & 0x07;
  
    /* Setting the Interrupt enable bit */
    IEC0bits.ADIE = (config & 0x08)>>3;
}

#endif
